package com.qkdata.biz.sms.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class SmsResponse {

    private Integer code;
    private String message;
    private Map<String, Object> data = new LinkedHashMap<>();
    private List<Object> errors;

    public boolean hasError() {
        return (code == null || code.intValue() != 0);
    }

}
