package com.qkdata.biz.management.vo;

import com.qkdata.biz.enums.AccountStatusEnum;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class EnterpriseListItemModel {
    private Long id;
    /**
     * 企业名称
     */
    private String name;
    /**
     * 管理员手机号
     */
    private String adminMobile;
    /**
     * 企业管理员姓名
     */
    private String adminName;
    /**
     * 管理员昵称
     */
    private String adminNickName;
    /**
     * 注册时间
     */
    private LocalDateTime createTime;
    /**
     * 管理员头像
     */
    private String adminAvatarUrl;
    /**
     * 管理员状态
     */
    private AccountStatusEnum adminStatus;
    /**
     * 最后登录时间
     */
    private LocalDateTime lastLoginTime;
    /**
     * 成员数量
     */
    private int memberCount;
    /**
     * 企业logo
     */
    private String logoUrl;
    /**
     * 省市
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 详细地址
     */
    private String address;

}
