package com.qkdata.biz.management.service;

import cn.hutool.core.util.StrUtil;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.vod.model.v20170321.GetVideoInfoResponse;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.aliyun.service.AliyunService;
import com.qkdata.biz.management.entity.CourseChapterPO;
import com.qkdata.biz.management.entity.CourseConsumeRecordPO;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.entity.ResourcePO;
import com.qkdata.biz.management.mapper.CourseChapterMapper;
import com.qkdata.biz.management.mapper.CourseConsumeRecordMapper;
import com.qkdata.biz.web.vo.CourseConsumeRecordModel;
import com.qkdata.biz.web.vo.QueryConsumeRecordModel;
import com.qkdata.biz.web.vo.SaveConsumeRecord;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.util.UserContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-09
 */
@Slf4j
@Service
public class CourseConsumeRecordService extends ServiceImpl<CourseConsumeRecordMapper, CourseConsumeRecordPO> {

    @Autowired
    private AliyunService aliyunService;
    @Autowired
    @Qualifier("objectRedisTemplate")
    private RedisTemplate redisTemplate;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseChapterMapper chapterMapper;
    @Autowired
    private ResourceService resourceService;

    public void removeBatch(List<Long> ids) {
        for (Long id : ids){
            CourseConsumeRecordPO po = getById(id);
            if (po != null){
                remove(Wrappers.<CourseConsumeRecordPO>lambdaQuery()
                        .eq(CourseConsumeRecordPO::getUserId,po.getUserId())
                        .eq(CourseConsumeRecordPO::getCourseId,po.getCourseId())
                        .eq(CourseConsumeRecordPO::getChapterId,po.getChapterId()));
            }
        }
    }

    public CourseConsumeRecordModel findUserCourseRecord(Long userId, Long courseId) {
        //先从缓存取用户观看记录
        String key = "record_"+userId+"_"+courseId;
        CourseConsumeRecordModel model = null;
        if (redisTemplate.hasKey(key)){
            SaveConsumeRecord userRecord = (SaveConsumeRecord) redisTemplate.opsForValue().get(key);
            model = new CourseConsumeRecordModel();
            model.setId(userRecord.getUuid());
            model.setUserId(userId);
            model.setCourseId(courseId);
            model.setChapterId(userRecord.getChaperId());
            model.setWatchTime(userRecord.getLearnDuration());
            model.setVideoTime(userRecord.getVideoDuration());
            model.setUpdateTime(userRecord.getStartTime());
            CoursePO coursePO = courseService.getById(courseId);
            model.setCourseName(coursePO.getName());
            model.setCourseStatus(coursePO.getStatus());
            CourseChapterPO chapterPO = chapterMapper.selectById(userRecord.getChaperId());
            model.setChapterId(chapterPO.getId());
            model.setChapterName(chapterPO.getName());
            ResourcePO resourcePO = resourceService.getById(chapterPO.getResourceId());
            model.setVideoId(resourcePO.getVideoId());
            model.setUpdateTime(userRecord.getStartTime());
            appendChapterShapshot(model);
        }else {
            model = baseMapper.queryUserCourseRecord(userId,courseId);
            appendChapterShapshot(model);
        }

        return model;
    }

    private void appendChapterShapshot(CourseConsumeRecordModel model) {
        String videoId = model.getVideoId();
        if (StrUtil.isNotBlank(videoId)){
            try {
                GetVideoInfoResponse response = aliyunService.getVideoInfo(videoId);
                String url = response.getVideo().getCoverURL();
                model.setLogoUrl(url);
            } catch (ClientException e) {
                log.error(e.getMessage(),e);
            }
        }
    }

    public PageResult<CourseConsumeRecordModel> queryUserRecordPageList(QueryConsumeRecordModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<CourseConsumeRecordModel> list = baseMapper.queryUserRecordPage(page,model);
        for (CourseConsumeRecordModel record : list){
            appendChapterShapshot(record);
        }
        return PageResult.<CourseConsumeRecordModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

}