package com.qkdata.biz.sys.vo;

import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.enums.AccountTypeEnum;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MemberListModel {
    /**
     * 用户ID
     */
    private Long id;
    /**
     * 用户帐号
     */
    private String username;
    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 头像
     */
    private String avatarUrl;
    /**
     * 注册时间
     */
    private LocalDateTime createTime;
    /**
     * 用户状态
     */
    private AccountStatusEnum status;
    /**
     * 用户类型
     */
    private AccountTypeEnum type;
    /**
     * 所属企业ID
     */
    private Long enterpriseId;
    /**
     * 所属企业名称
     */
    private String enterpriseName;
    /**
     * 最后登陆时间
     */
    private LocalDateTime lastLoginTime;
    /**
     * 会员生效时间
     */
    private LocalDateTime vipStartTime;
    /**
     * 会员失效时间
     */
    private LocalDateTime vipEndTime;
}
