package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.sys.mapper.SysUserExtMapper;
import com.qkdata.biz.sys.vo.MemberListModel;
import com.qkdata.biz.sys.vo.QueryMemberModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class MemberService {
    @Autowired
    private SysUserExtMapper sysUserExtMapper;

    public PageResult<MemberListModel> queryPage(QueryMemberModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<MemberListModel> list = sysUserExtMapper.queryPage(page,param);
        return PageResult.<MemberListModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }
}
