package com.qkdata.biz.management.controller;

import com.qkdata.biz.management.service.MemberService;
import com.qkdata.biz.sys.vo.MemberListModel;
import com.qkdata.biz.sys.vo.QueryMemberModel;
import com.qkdata.common.base.model.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "客户管理")
@RestController
@RequestMapping("/api/mgr/member")
public class MemberController {

    @Autowired
    private MemberService memberService;

    @ApiOperation("查询客户列表")
    @PostMapping("/list")
    public PageResult<MemberListModel> list(@RequestBody QueryMemberModel param){
        return memberService.queryPage(param);
    }
}
