package com.qkdata.alipay.controller;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.qkdata.alipay.config.AlipayProperties;
import com.qkdata.biz.enums.ProductOrderStatusEnum;
import com.qkdata.biz.management.service.ProductOrderService;
import com.qkdata.common.base.exception.BusinessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Slf4j
@Api
@RestController
@RequestMapping("/alipay")
public class AlipayNotifyController {
    @Autowired
    private AlipayProperties alipayProperties;
    @Autowired
    private ProductOrderService orderService;

    @ApiOperation(value = "支付回调通知处理")
    @PostMapping("/notify/order")
    public String parseOrderNotifyResult(HttpServletRequest request) throws WxPayException {
        Map<String,String> params = parseParameter(request);
        log.info(JSONObject.toJSONString(params));
        //商户订单号
        String out_trade_no = params.get("out_trade_no");
        //支付宝交易号
        String trade_no = params.get("trade_no");
        //交易状态
        String trade_status = params.get("trade_status");

        try {
            //计算得出通知验证结果
            boolean verify_result = AlipaySignature.rsaCheckV1(params, alipayProperties.getAlipayPublicKey(), "UTF-8", "RSA2");
            if (verify_result){
                //验证成功
                if(trade_status.equals("TRADE_SUCCESS")){
                    orderService.orderComplete(out_trade_no);
                } else if (trade_status.equals("TRADE_FINISHED")){

                }else if (trade_status.equals("WAIT_BUYER_PAY")){
                    orderService.updateStatus(out_trade_no, ProductOrderStatusEnum.WAIT_PAY);
                }
            }else {
                //验证失败
                throw new BusinessException("非法请求");
            }
        } catch (AlipayApiException e) {
            log.error(e.getMessage(),e);
            orderService.updateStatus(out_trade_no, ProductOrderStatusEnum.PAY_FAILD);
            return "fail";
        }
        return "success";
    }
    private Map<String,String> parseParameter(HttpServletRequest request){
        //获取支付宝POST过来反馈信息
        Map<String,String> params = new HashMap<String,String>();
        Map requestParams = request.getParameterMap();
        for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
            String name = (String) iter.next();
            String[] values = (String[]) requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; i++) {
                valueStr = (i == values.length - 1) ? valueStr + values[i]
                        : valueStr + values[i] + ",";
            }
            //乱码解决，这段代码在出现乱码时使用。如果mysign和sign不相等也可以使用这段代码转化
            //valueStr = new String(valueStr.getBytes("ISO-8859-1"), "gbk");
            params.put(name, valueStr);
        }
        return params;
    }

}
