package com.qkdata.biz.web.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.QuestionStatusEnum;
import com.qkdata.biz.management.service.QAService;
import com.qkdata.biz.management.vo.*;
import com.qkdata.biz.web.vo.AskModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "问答模块接口-手机端")
@RestController
@RequestMapping("/api/question")
public class FrontendQAController {
    @Autowired
    private QAService qaService;

    @ApiOperation("提问")
    @SysLog("提问")
    @PostMapping("/ask")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> ask(@RequestBody @Validated AskModel model){
        qaService.ask(model);
        return Result.succeed("ok");
    }

    @ApiOperation("我的提问列表")
    @SysLog("我的提问列表")
    @PostMapping("/myList")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<QuestionModel> myList(@RequestBody QueryQuestionModel param){
        param.setCondition(null);
        return qaService.myQuestionPageList(param);
    }
    @ApiOperation("问题回复列表")
    @SysLog("问题回复列表")
    @PostMapping("/replyList")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<QAModel> replyList(@RequestBody QueryAnswerModel param){
        return qaService.answerList(param);
    }
    @ApiOperation("补充提问题")
    @SysLog("补充提问题")
    @PostMapping("/reply")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> reply(@RequestBody AnswerModel model){
        qaService.answer(model);
        return Result.succeed("ok");
    }
    @ApiOperation("结束问答")
    @SysLog("结束问答")
    @GetMapping("/complete")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> complete(@RequestParam Long questionId){
        qaService.changeQuestionStatus(questionId, QuestionStatusEnum.COMPLETE);
        return Result.succeed("ok");
    }
    @ApiOperation("获取某个问题详细信息")
    @SysLog("获取某个问题详细信息")
    @GetMapping("/{questionId}")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<QuestionModel> getQuestion(@PathVariable Long questionId){
        QuestionModel model = qaService.getQuestion(questionId);
        return Result.succeed(model);
    }



}
