package com.qkdata.biz.sys.service;

import com.google.common.collect.Lists;
import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.common.tree.IContentProvider;
import com.qkdata.common.tree.ILabelProvider;
import com.qkdata.common.tree.TreeTypeEnum;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MenuTreeProvider implements IContentProvider, ILabelProvider {
    private List<SysMenuPO> menuList;

    @Override
    public List<? extends Object> getChildren(Object curElement, int level, int index) {
        SysMenuPO menuPO = (SysMenuPO) curElement;
        List<SysMenuPO> children = Lists.newArrayList();
        for (SysMenuPO sysMenuPO : menuList) {
            if (sysMenuPO.getParentId().longValue() == menuPO.getId().longValue()){
                children.add(sysMenuPO);
            }
        }
        return children;
    }

    @Override
    public List<? extends Object> getRootElement(List<?> treeData, int level, int index) {
        menuList = (List<SysMenuPO>) treeData;
        return menuList.stream().filter(menu -> menu.getParentId() == 0).collect(Collectors.toList());
    }

    @Override
    public boolean hasChild(Object curElement, int level, int index) {
        SysMenuPO menuPO = (SysMenuPO) curElement;
        boolean flag = false;
        for (SysMenuPO sysMenuPO : menuList) {
            if (sysMenuPO.getParentId().longValue() == menuPO.getId().longValue()){
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    public TreeTypeEnum getLabelType(Object curElement, int level, int index) {
        return TreeTypeEnum.NORMAL;
    }

    @Override
    public String getLabelName(Object curElement, int level, int index) {
        SysMenuPO menuPO = (SysMenuPO) curElement;
        return menuPO.getName();
    }

    @Override
    public Object getLabelId(Object curElement, int level, int index) {
        SysMenuPO menuPO = (SysMenuPO) curElement;
        return menuPO.getId();
    }

    @Override
    public String getIcon(Object curElement, int level, int index) {
        SysMenuPO menuPO = (SysMenuPO) curElement;
        return menuPO.getIcon();
    }

    @Override
    public boolean isDefaultIcon(Object curElement, int level, int index) {
        return false;
    }

    @Override
    public boolean isClick(Object curElement, int level, int index) {
        return false;
    }

    @Override
    public boolean isCheck(Object curElement, int level, int index) {
        return false;
    }

    @Override
    public String getCheckId(Object curElement, int level, int index) {
        return null;
    }

    @Override
    public Map<String, String> getAttributes(Object curElement, int level, int index) {
        return null;
    }
}
