package com.qkdata.biz.sms.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmsV2Condition {
    /**
     * 要发送的手机号
     */
    private String mobile;
    /**
     * 模板编号
     */
    private String code;
    /**
     * 模板参数
     */
    private Map<String,Object> params;
    /**
     * outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
     */
    private String outId;
    private String notifyUrl;

    public SmsV2Condition(String mobile, String code, Map<String,Object> params, String outId) {
        this.mobile = mobile;
        this.code = code;
        this.params = params;
        this.outId = outId;

    }
}
