package com.qkdata.biz.management.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.UserTagPO;
import com.qkdata.biz.management.service.UserTagService;
import com.qkdata.biz.management.vo.QueryUserTagModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 用户标签 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-09-01
 */
@Api(tags = "用户标签管理")
@RestController
@RequestMapping("/api/mgr/userTag")
public class UserTagController {
    @Autowired
    private UserTagService userTagService;

    @ApiOperation("添加用户标签")
    @PostMapping("/save")
    @SysLog(value = "添加用户标签")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> save(@RequestBody @Validated UserTagPO userTagPO){
        UserTagPO dbPO = userTagService.getOne(Wrappers.<UserTagPO>lambdaQuery().eq(UserTagPO::getName,userTagPO.getName()));
        if (dbPO != null){
            throw new BusinessException("标签名称已存在");
        }
        userTagService.save(userTagPO);
        return Result.succeed("ok");
    }
    @ApiOperation("删除标签")
    @GetMapping("/delete/{id}")
    @SysLog(value = "删除用户标签")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@PathVariable Long id){

        int count = userTagService.countByUserTagId(id);
        if (count > 0){
            throw new BusinessException("请先解除用户与该标签的关联");
        }
        userTagService.removeById(id);
        return Result.succeed("ok");
    }
    @ApiOperation("分页查询标签列表")
    @PostMapping("/list")
    @SysLog(value = "标签列表")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<UserTagPO> list(@RequestBody QueryUserTagModel params){
        return userTagService.queryPageList(params);
    }

}
