package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.service.CourseTagService;
import com.qkdata.biz.management.vo.QueryCourseTagModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 课程标签 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-14
 */
@Api(tags = "课程标签管理")
@RestController
@RequestMapping("/api/mgr/courseTag")
public class CourseTagController {

    @Autowired
    private CourseTagService courseTagService;

    @ApiOperation("添加课程标签")
    @PostMapping("/save")
    @SysLog(value = "添加课程标签")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> save(@RequestBody CourseTagPO courseTag){
        courseTagService.save(courseTag);
        return Result.succeed("ok");
    }
    @ApiOperation("修改课程标签")
    @PostMapping("/update")
    @SysLog(value = "修改课程标签")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> update(@RequestBody CourseTagPO courseTag){
        courseTagService.updateById(courseTag);
        return Result.succeed("ok");
    }
    @ApiOperation("删除课程标签")
    @PostMapping("/delete")
    @SysLog(value = "删除课程标签")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@RequestBody List<Long> ids){
        courseTagService.removeByIds(ids);
        return Result.succeed("ok");
    }
    @ApiOperation("查询课程标签")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("查询课程标签")
    public PageResult<CourseTagPO> list(@RequestBody QueryCourseTagModel param){
        return courseTagService.queryPageList(param);
    }


}
