package com.qkdata.biz.sys.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.sys.entity.SysRoleMenuPO;
import com.qkdata.biz.sys.mapper.SysRoleMenuMapper;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class SysRoleMenuService extends BaseServiceImpl<SysRoleMenuMapper, SysRoleMenuPO> {
    public List<Long> queryMenuIdList(Long roleId) {
        return baseMapper.selectMenuIdsByRoleId(roleId);
    }
    @Transactional
    public void saveOrUpdateRoleMenu(Long roleId, List<Long> menuIdList) {
        deleteByRoleIds(new Long[]{roleId});

        if (CollectionUtils.isEmpty(menuIdList)){
            return;
        }
        for (Long menuId : menuIdList){
            SysRoleMenuPO po = new SysRoleMenuPO();
            po.setRoleId(roleId);
            po.setMenuId(menuId);
            save(po);
        }
    }

    private void deleteByRoleIds(Long[] roleIds) {
        baseMapper.delete(Wrappers.<SysRoleMenuPO>lambdaQuery().in(SysRoleMenuPO::getRoleId,roleIds));
    }

    public List<Long> findRoleMenuIds(Long roleId) {
        return baseMapper.findRoleMenuIds(roleId);
    }
}
