package com.qkdata.common.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qkdata.common.trace.HttpTraceLogFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
public class HttpTraceConfiguration {

    @Configuration
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    static class ServletTraceFilterConfiguration {

        @Bean
        @ConditionalOnMissingBean
        public HttpTraceLogFilter httpTraceLogFilter(ObjectMapper objectMapper) {
            return new HttpTraceLogFilter(objectMapper);
        }

    }
}
