package com.qkdata.common.tree;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liu_yang
 * 树对象
 *
 */
public class Tree {
	/**
     * <code>childs</code> - 树子节点.
     */
    private List<TreeNode> m_roots = new ArrayList<TreeNode>();

    /**
     * 树ID
     */
    private String m_id = "";

    /**
     * Constructors.
     *
     * @param id 树ID
     */
    public Tree(final String id) {
        this.m_id = id;
    }

    /**
     * Constructors.
     *
     * @param id 树ID
     * @param roots 子节点TreeNode
     */
    public Tree(final String id, final List<TreeNode> roots) {
        this.m_roots = roots;
        this.m_id = id;
    }


    /**
     * 添加子节点
     *
     * @param treeNode TreeNode节点对象
     */
    public void addChild(final TreeNode treeNode) {
        this.m_roots.add(treeNode);
    }

    /**
     * 获取List<TreeNode>树
     *
     * @return List<TreeNode>
     */
    public List<TreeNode> getRoots() {
        return this.m_roots;
    }

    /**
     * @return id - {return content description}
     */
    public String getId() {
        return m_id;
    }

    /**
     * @param id - {parameter description}.
     */
    public void setId(final String id) {
        m_id = id;
    }


}
