package com.qkdata.biz.web.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.enums.SwiperStatusEnum;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.entity.TeacherPO;
import com.qkdata.biz.management.service.*;
import com.qkdata.biz.management.vo.CourseDetailModel;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.management.vo.TeacherModel;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.MainPageModel;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "首页数据获取-手机端")
@RestController
@RequestMapping("/api/web/mainPage")
public class MainPageController {
    @Autowired
    private SwiperConfigService swiperConfigService;
    @Autowired
    private CourseTagService courseTagService;
    @Autowired
    private RecommendConfigService recommendConfigService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private TeacherService teacherService;

    @ApiOperation("获取配置信息")
    @GetMapping("")
    @SysLog("获取配置信息")
    public Result<MainPageModel> get(){
        List<SwiperConfigModel> swiperConfigModels = swiperConfigService.listConfig(SwiperStatusEnum.ENABLE);
        List<CourseTagPO> tagList = courseTagService.list(Wrappers.<CourseTagPO>lambdaQuery().eq(CourseTagPO::getRecommend,true));
        MainPageModel model = new MainPageModel();
        model.setTags(tagList);
        model.setSwiperConfigs(swiperConfigModels);

        return Result.succeed(model);
    }
    @ApiOperation("首页推存课程列表")
    @PostMapping("/course/recommend/list")
    @SysLog("首页推存课程列表")
    public PageResult<SearchCourseResultModel> recommendCourseList(@RequestBody SearchCourseConditionModel model){
        return courseService.mainPageRecommendList(model);
    }

    @ApiOperation("搜索课程")
    @PostMapping("/course/search")
    @SysLog("搜索课程")
    public PageResult<SearchCourseResultModel> searchCourse(@RequestBody SearchCourseConditionModel model){
        return courseService.search(model);
    }

    @ApiOperation("获取全部标签")
    @GetMapping("/course/tags")
    @SysLog("获取全部标签")
    public Result<List<CourseTagPO>> findCourseTags(){
        List<CourseTagPO> tags = tagService.list();
        return Result.succeed(tags);
    }

    @ApiOperation("详情页关联课程推荐")
    @GetMapping("/course/recommend/{courseId}")
    @SysLog("详情页关联课程推荐")
    public Result<List<SearchCourseResultModel>> courseRecommend(Long courseId){
        List<SearchCourseResultModel> list = courseService.relationRecommend(courseId);
        return Result.succeed(list);
    }

    @ApiOperation("获取教师信息")
    @GetMapping("/teacher/{teacherId}")
    @SysLog("获取教师信息")
    public Result<TeacherPO> getTeacherInfo(@PathVariable Long teacherId){
        return Result.succeed(teacherService.getById(teacherId));
    }

}
