package com.qkdata.biz.management.vo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class TeacherModel {
    private Long id;
    /**
     * 编号
     */
    private String code;

    /**
     * 姓名
     */
    @NotBlank(message = "讲师姓名不能为空")
    private String name;

    /**
     * 电话
     */
    private String mobile;

    /**
     * 所属机构ID
     */
    @NotNull(message = "所属机构不能为空")
    private Long orgId;
    /**
     * 所属机构名称
     */
    private String orgName;

    /**
     * 简介
     */
    private String introduce;
    /**
     * 课程数量
     */
    private int courseCount;

}
