package com.qkdata.biz.management.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.PayMethodEnum;
import com.qkdata.biz.enums.ProductOrderStatusEnum;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 产品订单
 * </p>
 *
 * @author liuyang
 * @since 2021-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("product_order")
public class ProductOrderPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 产品类型（个人包月、企业包月、付费点播）
     */
    private ProductTypeEnum productType;

    /**
     * 课程ID
     */
    private Long courseId;

    /**
     * 产品单价
     */
    private BigDecimal productPrice;

    /**
     * 产品购买数量
     */
    private Integer productCount;

    /**
     * 订单金额
     */
    private BigDecimal orderMoney;

    /**
     * 支付金额
     */
    private BigDecimal paymentMoney;

    /**
     * 支付方式（微信、支付宝）
     */
    private PayMethodEnum payMethod;

    /**
     * 订单状态
     */
    private ProductOrderStatusEnum status;


}
