package com.qkdata.biz.management.controller;

import com.qkdata.biz.management.service.MemberService;
import com.qkdata.biz.management.service.UserTagService;
import com.qkdata.biz.management.vo.MemberListModel;
import com.qkdata.biz.management.vo.QueryMemberModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "客户管理")
@RestController
@RequestMapping("/api/mgr/member")
public class MemberController {

    @Autowired
    private MemberService memberService;
    @Autowired
    private UserTagService userTagService;

    @ApiOperation("查询客户列表")
    @PostMapping("/list")
    @SysLog("查询客户列表")
    public PageResult<MemberListModel> list(@RequestBody QueryMemberModel param){
        return memberService.queryPage(param);
    }
    @ApiOperation("添加用户标签")
    @PostMapping("/addUserTags/{userId}")
    @SysLog("添加用户标签")
    public Result<String> addTags(@PathVariable Long userId, @RequestBody List<Long> tagIds){
        userTagService.addUserTagRel(userId,tagIds);
        return Result.succeed("ok");
    }
}
