package com.qkdata.common.tree;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liu_yang 生成树方法
 *
 */
public class TreeView {

	/**
	 * <code>m_treeData</code> - 树内容原始对象.
	 */
	private List<? extends Object> m_treeData;
	/**
	 * <code>m_contentProvider</code> - 内容提供者.
	 */
	private IContentProvider m_contentProvider;
	/**
	 * <code>m_labelProvider</code> - 节点内容提供者.
	 */
	private ILabelProvider m_labelProvider;

	/**
	 * 生成树对象的构造方法
	 * @param treeData 生成树结构的数据
	 * @param contentProvider 树节点内容提供者
	 * @param labelProvider 树节点label显示内容提供者
	 */
	public TreeView(List<? extends Object> treeData,IContentProvider contentProvider,ILabelProvider labelProvider){
		this.m_treeData=treeData;
		this.m_contentProvider=contentProvider;
		this.m_labelProvider=labelProvider;
	}
	/**
	 * 构造树.
	 * 
	 * @param treeId
	 *            Tree ID
	 * @return Tree对象
	 * @throws ServiceException
	 *             Service异常
	 */
	public Tree buildTree(final String treeId) {
		List<TreeNode> t_rootList = new ArrayList<TreeNode>();
		TreeNode t_treeNode = null;

		List<? extends Object> t_rootObjectList = m_contentProvider.getRootElement(this.m_treeData, 0, 0);
		if (t_rootObjectList != null) {

			for (int t_i = 0; t_i < t_rootObjectList.size(); t_i++) {
				Object t_rootObject = t_rootObjectList.get(t_i);
				t_treeNode = createTreeNode(t_rootObject, 0, t_i);
				recursionNodes(this.m_contentProvider.getChildren(t_rootObject, 0, t_i), t_treeNode, 0);
				t_rootList.add(t_treeNode);
			}
		}
		Tree t_tree = new Tree(treeId, t_rootList);
		return t_tree;
	}


	/**
	 * 递归树节点.
	 * 
	 * @param objectList
	 *            树原始对象集合
	 * @param parentTreeNode
	 *            父树节点
	 * @param level
	 *            树节点集合
	 * @throws ServiceException
	 *             异常
	 */
	private void recursionNodes(final List<? extends Object> objectList, final TreeNode parentTreeNode,
			final int level) {
		int t_level = level + 1;
		TreeNode t_treeNode = null;
		if (objectList != null) {
			for (int t_i = 0; t_i < objectList.size(); t_i++) {
				Object t_childObject = objectList.get(t_i);
				t_treeNode = createTreeNode(t_childObject, t_level, t_i);
				parentTreeNode.addChild(t_treeNode);
				recursionNodes(this.m_contentProvider.getChildren(t_childObject, t_level, t_i), t_treeNode, t_level);
			}
		}
	}

	/**
	 * 创建树节点.
	 * 
	 * @param o
	 *            节点原始对象
	 * @param level
	 *            节点级别
	 * @param index
	 *            节点同级索引
	 * @return 创建的树节点
	 */
	private TreeNode createTreeNode(final Object o, final int level, final int index) {

		TreeNode t_treeNode = new TreeNode(this.m_labelProvider.getLabelId(o, level, index),
				this.m_labelProvider.getAttributes(o, level, index));

		if (this.m_contentProvider.hasChild(o, level, index)) {
			t_treeNode.setIsExpand(true);
		} else {
			t_treeNode.setIsExpand(false);
		}
		t_treeNode.setName(this.m_labelProvider.getLabelName(o, level, index));
		t_treeNode.setIcon(this.m_labelProvider.getIcon(o, level, index));
		t_treeNode.setIsClick(this.m_labelProvider.isClick(o, level, index));
		t_treeNode.setIsCheck(this.m_labelProvider.isCheck(o, level, index));
		createTreeNodeType(o, level, index, t_treeNode);

		return t_treeNode;

	}



	/**
	 * 创建树节点类型.
	 * 
	 * @param o
	 *            Object
	 * @param level
	 *            级别
	 * @param index
	 *            索引
	 * @param treeNode
	 *            树节点
	 */
	private void createTreeNodeType(final Object o, final int level, final int index, final TreeNode treeNode) {
		TreeTypeEnum t_treeType = this.m_labelProvider.getLabelType(o, level, index);
		treeNode.setType(t_treeType.toString());
	}

}
