package com.qkdata.biz.sys.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.sys.entity.SysUserRolePO;
import com.qkdata.biz.sys.mapper.SysUserRoleMapper;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class SysUserRoleService extends BaseServiceImpl<SysUserRoleMapper, SysUserRolePO> {
    public List<Long> queryRoleIdList(Long userId) {
        return baseMapper.queryRoleIdList(userId);
    }

    public void saveOrUpdateUserRole(Long userId, List<Long> roleIdList) {
        if (!CollectionUtils.isEmpty(roleIdList)){
            //先删除用户与角色关系
            deleteByUserId(userId);
            //保存用户角色关系
            for (Long roleId : roleIdList){
                SysUserRolePO po = new SysUserRolePO();
                po.setUserId(userId);
                po.setRoleId(roleId);
                baseMapper.insert(po);
            }
        }
    }
    public void deleteByUserId(Long userId){
        baseMapper.delete(Wrappers.<SysUserRolePO>lambdaQuery().eq(SysUserRolePO::getUserId,userId));
    }

    public void deleteByUserIds(List<Long> userIds) {
        baseMapper.delete(Wrappers.<SysUserRolePO>lambdaQuery().in(SysUserRolePO::getUserId,userIds));
    }
}
