package com.qkdata.aliyun.controller;

import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoResponse;
import com.qkdata.aliyun.service.AliyunService;
import com.qkdata.aliyun.vo.AliyunOSSUploadPolicyModel;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.util.Map;

@Api(tags = "阿里云API")
@RestController
@RequestMapping("/api/aliyun/mgr")
public class AliyunApiController {
    @Autowired
    private AliyunService aliyunService;

    @ApiOperation("获取阿里云视视频上传所需配置信息")
    @GetMapping("/videoConfig")
    public Result<Map<String, String>> videoConfig() {
        return Result.succeed(aliyunService.getVideoConfig());
    }

    @ApiOperation("获取阿里云OSS上传所需要的参数")
    @GetMapping("/uploadPolicy")
    public Result<AliyunOSSUploadPolicyModel> getUploadPolicy() throws UnsupportedEncodingException {
        return Result.succeed(aliyunService.getUploadPolicy());
    }

    @ApiOperation("获取阿里云视频上传所需要的参数")
    @GetMapping("/videoUploadPolicy")
    public Result<CreateUploadVideoResponse> videoUploadPolicy(@RequestParam(required = true) String title, @RequestParam(required = true) String fileName) throws Exception {
        return Result.succeed(aliyunService.createUploadVideo(title,fileName));
    }

    @ApiOperation("刷新阿里云视频上传所需要的参数")
    @GetMapping("/refreshVideoUploadPolicy")
    public Result<RefreshUploadVideoResponse> refreshVideoUploadPolicy(@RequestParam(required = true) String videoId) throws Exception {
        return Result.succeed(aliyunService.refreshUploadVideo(videoId));
    }

}
