DROP TABLE IF EXISTS org_buy_course_record;
DROP TABLE IF EXISTS org_buy_vip_record;
DROP TABLE IF EXISTS user_get_vip_record;

ALTER TABLE `organization`
ADD COLUMN `vip_receive` varchar(10) NULL COMMENT '企业会员领取开放、关闭标识' AFTER `is_del`,
ADD COLUMN `course_receive` varchar(10) NULL COMMENT '企业会员点播库领取开放、关闭标识' AFTER `vip_receive`;

CREATE TABLE `user_course_auth`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NULL COMMENT '用户ID',
  `course_id` bigint(20) NULL COMMENT '课程ID',
  `start_time` datetime(0) NULL COMMENT '开始时间',
  `end_time` datetime(0) NULL COMMENT '结束时间',
  PRIMARY KEY (`id`)
) COMMENT = '用户课程授权表';

CREATE TABLE `org_surplus`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_id` bigint(20) NULL COMMENT '企业ID',
  `course_id` bigint(20) NULL COMMENT '课程ID',
  `product_type` varchar(20) NULL COMMENT '产品类型',
  `count` int(11) NULL COMMENT '剩余数量',
  PRIMARY KEY (`id`)
) COMMENT = '企业VIP或课程余额表';

CREATE TABLE `org_user_receive_record`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_id` bigint(20) NULL COMMENT '企业ID',
  `user_id` bigint(20) NULL COMMENT '用户ID',
  `product_type` varchar(20) NULL COMMENT '产品类型',
  `count` int(11) NULL COMMENT '领用或分配的数量',
  `course_id` bigint(11) NULL COMMENT '课程ID',
  `create_time` datetime(0) NULL,
  `update_time` datetime(0) NULL,
  PRIMARY KEY (`id`)
) COMMENT = '企业成员领用或分配记录表';