package com.qkdata.biz.management.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.ProductOrderService;
import com.qkdata.biz.management.vo.ProductOrderModel;
import com.qkdata.biz.management.vo.QueryProductOrderModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "订单管理")
@RestController
@RequestMapping("/api/mgr/order")
public class ProductOrderController {
    @Autowired
    private ProductOrderService orderService;

    @ApiOperation("订单查询")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog("订单查询")
    public PageResult<ProductOrderModel> list(@RequestBody QueryProductOrderModel model){
        return  orderService.queryPageList(model);
    }

}
