package com.qkdata.biz.sys.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.vo.LoginModel;
import com.qkdata.biz.sys.vo.LoginUserInfo;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(tags = "系统登陆")
@RestController
@RequestMapping("/api/sys")
public class SysLoginController {
    @Autowired
    private ShiroService shiroService;


    @ApiOperation("登陆")
    @SysLog("登陆")
    @PostMapping("/login")
    public Result<LoginUserInfo> login(@RequestBody @Valid LoginModel loginModel) throws JsonProcessingException {
        return Result.succeed(shiroService.login(loginModel.getUsername(),loginModel.getPassword()));
    }

    @ApiOperation("登出")
    @SysLog("登出")
    @GetMapping("/logout")
    public Result<String> logout(){
        SecurityUtils.getSubject().logout();
        return Result.succeed("ok");
    }
}
