package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.UserPayRecordTypeEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 企业会员领取记录
 * </p>
 *
 * @author liuyang
 * @since 2021-05-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("user_get_vip_record")
public class UserGetVipRecordPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 领取类型（月卡、付费点播课程）
     */
    private UserPayRecordTypeEnum type;

    /**
     * 课程ID
     */
    private Long courseId;

    /**
     * 企业ID
     */
    private Long orgId;


}
