package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.qkdata.common.base.entity.BasePO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * <p>
 * 课程消耗记录
 * </p>
 *
 * @author liuyang
 * @since 2021-06-09
 */
@Data
@TableName("course_consume_record")
public class CourseConsumeRecordPO {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.INPUT)
    private String id;
    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 观看时长（秒）
     */
    private Integer watchTime;

    /**
     * 课程ID
     */
    private Long courseId;

    /**
     * 章节ID
     */
    private Long chapterId;

    @ApiModelProperty(example = "1619423186000")
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;
    @ApiModelProperty(example = "1619423186000")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;


}
