CREATE TABLE `question`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NULL COMMENT '用户ID',
  `course_id` bigint(20) NULL COMMENT '课程ID',
  `chapter_id` bigint(20) NULL COMMENT '章节ID',
  `content` text NULL COMMENT '问题内容',
  `create_time` datetime(0) NULL,
  `update_time` datetime(0) NULL,
  `status` VARCHAR(20) NULL COMMENT '状态：待回复、已回复、已完成',
  PRIMARY KEY (`id`)
) COMMENT = '用户问题表';
CREATE TABLE `answer`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `question_id` bigint(20) NULL COMMENT '问题ID',
  `user_id` bigint(20) NULL COMMENT '回复人ID',
  `type` VARCHAR(20) NULL COMMENT '区分讲师回复还是用户回复',
  `content` text NULL COMMENT '内容',
  `create_time` datetime(0) NULL,
  `update_time` datetime(0) NULL,
  PRIMARY KEY (`id`)
) COMMENT = '问题回答表';

ALTER TABLE `teacher` ADD COLUMN `account` varchar(20) NULL COMMENT '讲师帐号' AFTER `avatar_url`;

INSERT INTO `sys_role` VALUES (6, 'TEACHER', '讲师', '2021-04-25 16:10:06', '2021-04-25 16:10:06');
