package com.qkdata.biz.management.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.enums.CourseStatusEnum;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.vo.CourseAllowEnterpriseModel;
import com.qkdata.biz.management.vo.CourseAttachmentModel;
import com.qkdata.biz.management.vo.CourseListItemModel;
import com.qkdata.biz.management.vo.QueryCourseModel;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 课程 Mapper 接口
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Mapper
public interface CourseMapper extends BaseMapper<CoursePO> {

    List<CourseListItemModel> queryPageList(Page page, @Param("p") QueryCourseModel param);

    void updateStatusById(@Param("id") Long id, @Param("status") CourseStatusEnum status);

    List<CourseAttachmentModel> selectAttachmentListByCourseId(Long id);

    List<CourseAllowEnterpriseModel> selectOrgListByCourseId(Long id);

    List<SearchCourseResultModel> searchPageList(Page page, @Param("p") SearchCourseConditionModel model);

    List<SearchCourseResultModel> recommendList(Page page, @Param("p") SearchCourseConditionModel model);

    List<CoursePO> findListByTags(List<Long> tagIds);
}
