package com.qkdata.biz.management.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.management.entity.TeacherPO;
import com.qkdata.biz.management.mapper.TeacherMapper;
import com.qkdata.biz.management.vo.QueryTeacherModel;
import com.qkdata.biz.management.vo.TeacherModel;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.sys.vo.SysUserModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-18
 */
@Service
public class TeacherService extends ServiceImpl<TeacherMapper, TeacherPO> {

    private String defaultNo = "00001";
    private String codePrefix = "TH";

    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private CourseService courseService;

    @Transactional
    public void saveModel(TeacherModel model) {
        TeacherPO po = new TeacherPO();
        BeanUtils.copyProperties(model,po);
        String dbMaxCode = findMaxNo();
        String teacherCode = getTeacherCode(dbMaxCode);
        po.setCode(teacherCode);
        super.save(po);
        //添加讲师帐号
        if (StrUtil.isNotBlank(po.getAccount())){
            addTeacherAccount(po.getAccount(),po.getName());
        }

    }

    /**
     * 添加讲师帐号
     * @param account
     * @param name
     */
    private void addTeacherAccount(String account, String name) {
        SysUserModel model = new SysUserModel();
        model.setUsername(account);
        model.setPassword("123456");
        model.setStatus(AccountStatusEnum.ENABLE);
        model.setNickName(name);
        model.setRoleIdList(Lists.newArrayList(6L));
        sysUserService.saveUser(model);
    }

    private String findMaxNo() {
        TeacherPO po = baseMapper.selectOne(Wrappers.<TeacherPO>lambdaQuery().orderByDesc(TeacherPO::getCode).last("limit 1"));
        if (po != null){
            return po.getCode();
        }
        return "";
    }

    private String getTeacherCode(String dbMaxCode){
        if (StrUtil.isNotBlank(dbMaxCode)){
            String noStr = StrUtil.sub(dbMaxCode,2,dbMaxCode.length());
            int no = Integer.parseInt(noStr);
            no++;
            String code = String.format("%05d",no);
            return StrUtil.format("{}{}",codePrefix,code);
        }
        return StrUtil.format("{}{}",codePrefix,defaultNo);
    }

    @Transactional
    public void updateModel(TeacherModel model) {
        TeacherPO po = getById(model.getId());
        if (po == null){
            throw new BusinessException("讲师不存在");
        }
        po.setName(model.getName());
        po.setMobile(model.getMobile());
        po.setIntroduce(model.getIntroduce());
        po.setOrgId(model.getOrgId());
        updateById(po);
        //添加讲师帐号
        if (StrUtil.isBlank(po.getAccount()) && StrUtil.isNotBlank(model.getAccount())){
            addTeacherAccount(model.getAccount(),po.getName());
        }
    }

    public PageResult<TeacherModel> queryPage(QueryTeacherModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<TeacherModel> list = baseMapper.queryPage(page,param);
        //TODO add courseCount
        for (TeacherModel model : list){
            int count = courseService.countByTeacher(model.getId());
            model.setCourseCount(count);
        }

        return PageResult.<TeacherModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    @Transactional
    public void removeTeachers(List<Long> ids) {
        for (Long id : ids){
            TeacherPO teacherPO = getById(id);
            removeById(id);
            //删除讲师帐号
            sysUserService.removeByUsername(teacherPO.getAccount());
        }
    }
}