package com.qkdata.biz.web.controller;

import com.aliyuncs.vod.model.v20170321.GetVideoPlayAuthResponse;
import com.google.common.base.Strings;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.CourseConsumeRecordService;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.ProductOrderService;
import com.qkdata.biz.management.vo.ProductOrderModel;
import com.qkdata.biz.management.vo.QueryFavoriteCourseModel;
import com.qkdata.biz.management.vo.QueryProductOrderModel;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.*;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "我的相关数据接口-手机端")
@RestController
@RequestMapping("/api/userCenter")
public class UserCenterController {
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private ProductOrderService orderService;
    @Autowired
    private CourseConsumeRecordService courseConsumeRecordService;
    @Value("${spring.profiles.active:default}")
    private String env;
    @Autowired
    @Qualifier("stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    @ApiOperation("获取个人信息")
    @GetMapping("/userInfo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取个人信息")
    public Result<FullUserInfo> userInfo(){
        String username = UserContext.getUser().getUsername();
        FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
        return Result.succeed(userInfo);
    }
    @ApiOperation("修改个人信息")
    @PostMapping("/userInfo/modify")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("修改个人信息")
    public Result<String> modifyUserInfo(@RequestBody ModifyUserInfoModel model){
        model.setId(UserContext.getUserId());
        sysUserService.modifyUserInfo(model);
        return Result.succeed("ok");
    }
    @ApiOperation("获取收藏列表")
    @PostMapping("/myFavorite/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取收藏列表")
    public PageResult<SearchCourseResultModel> myFavoriteList(@RequestBody QueryFavoriteCourseModel model){
        return userCenterService.myFavoriteQueryPageList(model);
    }
    @ApiOperation("删除收藏")
    @PostMapping("/myFavorite/remove")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("删除收藏")
    public Result<String> removeFavorite(@RequestBody List<Long> courseIds){
        userCenterService.removeFavorite(courseIds);
        return Result.succeed("ok");
    }

    @ApiOperation("收藏课程")
    @PostMapping("/course/favorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("收藏课程")
    public Result<String> favoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.favoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }
    @ApiOperation("取消收藏")
    @PostMapping("/course/removeFavorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("取消收藏")
    public Result<String> removeFavoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.removeFavoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }


    @ApiOperation("获取视频播放凭证")
    @GetMapping("/course/playVideo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取视频播放凭证")
    public Result<GetVideoPlayAuthResponse> getCoursePlayVideoUrl(@RequestParam Long courseId, @RequestParam Long chaperId){
        //验证权限
        userCenterService.checkCoursePlayPerm(courseId);
        GetVideoPlayAuthResponse response = courseService.getVideoPlayAuth(courseId,chaperId);

        return Result.succeed(response);
    }


    @ApiOperation("已购课程列表")
    @PostMapping("/course/buy/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("已购课程列表")
    public PageResult<BuyCourseListItem> buyCourseList(@RequestBody QueryBuyCourseListModel model){
        model.setUserId(UserContext.getUserId());
        return courseService.queryBuyCourseList(model);
    }
    @ApiOperation("用户购买记录列表")
    @PostMapping("/user/order/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("用户购买记录列表")
    public PageResult<ProductOrderModel> userOrderList(@RequestBody QueryProductOrderModel model){
        model.setUsername(UserContext.getUser().getUsername());
        return orderService.queryPageList(model);
    }


    @ApiOperation("用户观看记录列表")
    @PostMapping("/consumeRecord/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("用户观看记录列表")
    public PageResult<CourseConsumeRecordModel> consumeRecordList(@RequestBody QueryConsumeRecordModel model){
        model.setUserId(UserContext.getUserId());
        return courseConsumeRecordService.queryUserRecordPageList(model);
    }
    @ApiOperation("删除观看记录列表")
    @PostMapping("/consumeRecord/delete")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("删除观看记录列表")
    public Result<String> consumeRecordList(@RequestBody List<Long> courseIds){
        courseConsumeRecordService.removeByCourseIds(UserContext.getUserId(),courseIds);
        return Result.succeed("ok");
    }
    @ApiOperation("用户观看某课程的记录")
    @GetMapping("/user/consumeRecord")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("用户观看某课程的记录")
    public Result<CourseConsumeRecordModel> consumeRecordList(@RequestParam Long courseId){
        CourseConsumeRecordModel model = courseConsumeRecordService.findUserCourseRecordLast(UserContext.getUserId(),courseId);
        return Result.succeed(model);
    }
    @ApiOperation("查询用户是否已购买该课程")
    @GetMapping("/user/course/checkPerm")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("查询用户是否已购买该课程")
    public Result<Boolean> checkPerm(@RequestParam Long courseId){
        Boolean flag = true;
        try {
            userCenterService.checkCoursePlayPerm(courseId);
        }catch (BusinessException e){
            flag = false;
        }
        return Result.succeed(flag);
    }
    @ApiOperation("换绑-验证原手机号")
    @PostMapping("/user/checkMobile")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("换绑-验证原手机号")
    public Result<String> checkMobile(@RequestBody @Validated LoginByCodeModel model){
        checkMobileCode(model);
        String username = UserContext.getUser().getUsername();
        if (!username.equals(model.getMobile())){
            throw new BusinessException("手机号码与当前用户不一致");
        }
        SysUserPO user =  sysUserService.getByUsername(model.getMobile());
        if (user == null){
            throw new BusinessException("手机号码不存在");
        }
        return Result.succeed("ok");
    }
    @ApiOperation("换绑-变更手机号")
    @PostMapping("/user/changeMobile")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("换绑-变更手机号")
    public Result<String> changeMobile(@RequestBody @Validated LoginByCodeModel model){
        checkMobileCode(model);
        sysUserService.changeUsername(UserContext.getUser().getUsername(),model.getMobile());
        return Result.succeed("ok");
    }
    private void checkMobileCode(LoginByCodeModel model){
//        if (!"dev".equals(env)){
            String cache_captcha = (String) redisTemplate.opsForValue().get(BizConstants.MOBILE_CAPTCHA_PREFIX+model.getMobile());
            if (!Strings.isNullOrEmpty(cache_captcha)){
                cache_captcha = cache_captcha.trim();
                if (!cache_captcha.equals(model.getCode())){
                    log.error("验证码错误：redis值为{}，输入值为{}",cache_captcha,model.getCode());
                    throw new BusinessException("验证码错误");
                }
            }else {
                throw new BusinessException("验证码错误");
            }
//        }


    }


}
