package com.qkdata.biz.sms.controller;

import com.google.common.collect.Maps;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sms.service.SmsService;
import com.qkdata.biz.sms.vo.SendValCodeReq;
import com.qkdata.biz.sms.vo.SmsV2Condition;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.RandomDigitGenerator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.concurrent.TimeUnit;

@Api(tags = "发送短信服务")
@RestController
@RequestMapping("/api/sms")
public class SmsController {

    @Autowired
    private SmsService smsService;
    @Autowired
    @Qualifier("stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    @ApiOperation("发送验证码")
    @SysLog("发送验证码")
    @GetMapping("/sendCode")
    public Result<String> sendCode(@RequestBody @Validated SendValCodeReq req){
        Map<String,Object> param = Maps.newHashMap();
        String captcha = RandomDigitGenerator.generate(6);
        param.put("code",captcha);
        SmsV2Condition condition = new SmsV2Condition(req.getMobile(), BizConstants.SMS_TEMPLATE_CODE,param,null);
        smsService.sendSmsV3(condition);
        //将captcha存入Redis，过期时间为5分钟
        redisTemplate.opsForValue().set(BizConstants.MOBILE_CAPTCHA_PREFIX + req.getMobile(),captcha,60*5, TimeUnit.SECONDS);
        return Result.succeed("ok");
    }
}
