package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.entity.UserFavoritesPO;
import com.qkdata.biz.management.mapper.UserFavoritesMapper;
import com.qkdata.biz.management.vo.QueryFavoriteCourseModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserFavoritesService extends ServiceImpl<UserFavoritesMapper, UserFavoritesPO> {

    public UserFavoritesPO findByUserIdAndCourseId(Long userId, Long courseId) {
        return getOne(Wrappers.<UserFavoritesPO>lambdaQuery().eq(UserFavoritesPO::getUserId,userId).eq(UserFavoritesPO::getCourseId,courseId));
    }

    public void removeByUserIdAndCourseId(Long userId, Long courseId) {
        remove(Wrappers.<UserFavoritesPO>lambdaQuery().eq(UserFavoritesPO::getUserId,userId).eq(UserFavoritesPO::getCourseId,courseId));
    }

    public PageResult<SearchCourseResultModel> queryPageList(QueryFavoriteCourseModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<SearchCourseResultModel> list = baseMapper.queryPageList(page,model);
        return PageResult.<SearchCourseResultModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }
}
