package com.qkdata.biz.web.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.entity.RecommendConfigPO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.CourseTagService;
import com.qkdata.biz.management.service.RecommendConfigService;
import com.qkdata.biz.management.service.SwiperConfigService;
import com.qkdata.biz.management.vo.CourseDetailModel;
import com.qkdata.biz.management.vo.CourseTagsModel;
import com.qkdata.biz.management.vo.RecommendConfigModel;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.web.vo.MainPageModel;
import com.qkdata.biz.web.vo.SearchCourseConditionModel;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "首页数据获取")
@RestController
@RequestMapping("/api/web/mainPage")
public class MainPageController {
    @Autowired
    private SwiperConfigService swiperConfigService;
    @Autowired
    private CourseTagService courseTagService;
    @Autowired
    private RecommendConfigService recommendConfigService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CourseTagService tagService;

    @ApiOperation("获取配置信息")
    @GetMapping("")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<MainPageModel> get(){
        List<SwiperConfigModel> swiperConfigModels = swiperConfigService.listConfig();
        List<CourseTagPO> tagList = courseTagService.list(Wrappers.<CourseTagPO>lambdaQuery().eq(CourseTagPO::getRecommend,true));
        List<RecommendConfigModel> recommendConfigList = recommendConfigService.listConfig();
        MainPageModel model = new MainPageModel();
        model.setTags(tagList);
        model.setSwiperConfigs(swiperConfigModels);
        model.setRecommendConfigs(recommendConfigList);

        return Result.succeed(model);
    }

    @ApiOperation("搜索课程")
    @PostMapping("/course/search")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("搜索课程")
    public PageResult<SearchCourseResultModel> searchCourse(@RequestBody SearchCourseConditionModel model){
        return courseService.search(model);
    }

    @ApiOperation("获取全部标签")
    @GetMapping("/course/tags")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<List<CourseTagPO>> findCourseTags(){
        List<CourseTagPO> tags = tagService.list();
        return Result.succeed(tags);
    }
    @ApiOperation("获取课程详情")
    @GetMapping("/course/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取课程详情")
    public Result<CourseDetailModel> getCourseDetail(@PathVariable Long id){
        courseService.checkPerm(id);
        CourseDetailModel model = courseService.getCourseDetail(id);
        return Result.succeed(model);
    }
}
