package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.aliyuncs.exceptions.ClientException;
import com.google.common.collect.Lists;
import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.entity.RecommendConfigPO;
import com.qkdata.biz.management.entity.ResourcePO;
import com.qkdata.biz.management.mapper.RecommendConfigMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.vo.CourseChaperModel;
import com.qkdata.biz.management.vo.RecommendConfigModel;
import com.qkdata.biz.management.vo.VideoInfoModel;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.common.util.UserContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-27
 */
@Slf4j
@Service
public class RecommendConfigService extends ServiceImpl<RecommendConfigMapper, RecommendConfigPO> {
    @Autowired
    private CourseService courseService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private SysUserService sysUserService;

    public List<RecommendConfigModel> listConfig() {
        List<RecommendConfigModel> modelList = baseMapper.listConfig();
        List<RecommendConfigModel> resultList = Lists.newArrayList();
        for (RecommendConfigModel model : modelList){
            if (model.getAllow() == CourseAllowEnum.SPECIFY){
                List<Long> orgIds = courseService.getAllowEnterpriseList(model.getCourseId());
                String username = UserContext.getUser().getUsername();
                FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
                boolean hasPerm = false;
                for (Long orgId : orgIds){
                    if (userInfo.getEnterpriseId() != null){
                        if (orgId.longValue() == userInfo.getEnterpriseId().longValue()){
                            hasPerm = true;
                            break;
                        }
                    }
                }
                if (hasPerm){
                    resultList.add(model);
                }else {
                    continue;
                }
            }else {
                resultList.add(model);
            }
            List<CourseChaperModel> chaperList = courseService.chaperList(model.getCourseId());
            if (CollUtil.isNotEmpty(chaperList)){
                CourseChaperModel chaperModel = chaperList.get(0);
                ResourcePO resourcePO = resourceService.getById(chaperModel.getResourceId());
                if (resourcePO != null){
                    model.setDuration(resourcePO.getVideoDuration());

                }
            }
            List<CourseTagPO> tagList = tagService.findListByCourseId(model.getCourseId());
            model.setTags(tagList);
        }
        return resultList;
    }
}