package com.qkdata.common.jwt;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Set;

@Data
@ConfigurationProperties(prefix = "jwt")
public class JWTProperties {

    private String typ = "JWT";

    private String alg = "HS256";

    private String secret;

    private String iss = "qkdata";

    private String aud;

    private Integer exp = 2;

    /**
     * 是否启用拦截器
     */
    private Boolean enableInterceptor = Boolean.FALSE;

    /**
     * 需要拦截的URL
     */
    private Set<String> includeUrls;

    /**
     * 需要排除的URL
     */
    private Set<String> excludeUrls;
}
