package com.qkdata.biz.sys.vo;

import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.common.constants.AddGroup;
import com.qkdata.common.constants.UpdateGroup;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
public class SysUserModel {
    private Long id;
    @NotBlank(message = "用户名不能为空",groups = {AddGroup.class, UpdateGroup.class})
    private String username;
    @NotBlank(message = "密码不能为空",groups = AddGroup.class)
    private String password;
    private String email;
    private String mobile;
    private AccountStatusEnum status;
    private List<Long> roleIdList;
}
