package com.qkdata.biz.sys.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.mapper.SysUserMapper;
import com.qkdata.biz.sys.vo.QueryUserModel;
import com.qkdata.biz.sys.vo.SysUserModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import com.qkdata.common.util.UserContext;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

@Service
public class SysUserService extends BaseServiceImpl<SysUserMapper, SysUserPO> {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    public SysUserPO getByUsername(String username) {
        return baseMapper.selectOne(Wrappers.<SysUserPO>lambdaQuery().eq(SysUserPO::getUsername,username));
    }

    public List<String> queryAllPerms(Long userId) {
        return baseMapper.queryAllPerms(userId);
    }

    public PageResult<SysUserModel> queryPageList(QueryUserModel queryUserModel) {
        Page<SysUserModel> page = new Page<>(queryUserModel.getPageIndex(),queryUserModel.getPageSize());
        List<SysUserModel> pageList = baseMapper.queryPageList(page,queryUserModel);
        return PageResult.<SysUserModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public List<Long> queryRoleIdList(Long userId) {
        return sysUserRoleService.queryRoleIdList(userId);
    }

    @Transactional
    public void saveUser(SysUserModel sysUserModel) {
        SysUserPO po = getByUsername(sysUserModel.getUsername());
        if (po != null){
            throw new BusinessException("帐号已存在");
        }
        po = new SysUserPO();
        BeanUtils.copyProperties(sysUserModel,po);
        po.setSalt(RandomStringUtils.randomAlphanumeric(20));
        po.setPassword(new Sha256Hash(sysUserModel.getPassword(), po.getSalt()).toHex());
        save(po);
        sysUserRoleService.saveOrUpdateUserRole(po.getId(),sysUserModel.getRoleIdList());
    }

    @Transactional
    public void updateUser(SysUserModel sysUserModel) {
        SysUserPO po = getById(sysUserModel.getId());
        if (po == null){
            throw new BusinessException("请求错误，用户不存在");
        }
        po.setUsername(sysUserModel.getUsername());
        if (!StringUtils.isEmpty(sysUserModel.getPassword())){
            po.setPassword(new Sha256Hash(sysUserModel.getPassword(),po.getSalt()).toHex());
        }
        po.setStatus(sysUserModel.getStatus());
        updateById(po);

        sysUserRoleService.saveOrUpdateUserRole(po.getId(),sysUserModel.getRoleIdList());
    }

    public void updatePassword(SysUserPO user, String password, String newPassword) {
        //sha256加密
        String pwd = new Sha256Hash(password, UserContext.getUser().getSalt()).toHex();
        if (!user.getPassword().equals(pwd)){
            throw new BusinessException("密码错误");
        }
        //sha256加密
        String newPwd = new Sha256Hash(newPassword, UserContext.getUser().getSalt()).toHex();
        user.setPassword(newPwd);
        updateById(user);
    }

    @Transactional
    public void removeUsers(List<Long> ids) {
        removeByIds(ids);
        sysUserRoleService.deleteByUserIds(ids);
    }
}
