package com.qkdata.common.converter;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.util.Date;
/**
 * 用于@RequestBody中Date类型参数序列化与反序列化
 */
public class DateSerializer extends JsonSerializer<Date> {
    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        if (value == null) {
            return;
        }
        gen.writeString(DateUtil.formatDateTime(value));
    }
}
