package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.management.entity.OrganizationPO;
import com.qkdata.biz.management.mapper.OrganizationMapper;
import com.qkdata.biz.management.vo.InstitutionModel;
import com.qkdata.biz.management.vo.QueryOrgModel;
import com.qkdata.common.base.entity.BasePO;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-04-27
 */
@Service
public class OrganizationService extends BaseServiceImpl<OrganizationMapper, OrganizationPO> {

    @Override
    public boolean save(OrganizationPO po) {
        OrganizationPO dbPO = getByName(po.getName());
        if (dbPO != null && dbPO.getType() == po.getType()) {
            throw new BusinessException("该机构名称已存在");
        }
        return super.save(po);
    }

    private OrganizationPO getByName(String name) {
        return baseMapper.selectOne(Wrappers.<OrganizationPO>lambdaQuery().eq(OrganizationPO::getName, name));
    }

    @Override
    public boolean updateById(OrganizationPO po) {
        OrganizationPO dbPO = baseMapper.selectOne(Wrappers.<OrganizationPO>lambdaQuery().eq(OrganizationPO::getName, po.getName())
                .eq(OrganizationPO::getType,po.getType())
                .ne(BasePO::getId, po.getId()));
        if (dbPO != null){
            throw new BusinessException("该机构名称已存在");
        }
        dbPO = getById(po.getId());
        if (dbPO == null){
            throw new BusinessException("请求错误，数据不存在");
        }
        return super.updateById(po);
    }


    public PageResult<OrganizationPO> queryPageList(QueryOrgModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<OrganizationPO> pageList = baseMapper.queryPageList(page,param);
        return PageResult.<OrganizationPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }
}