package com.qkdata.common.config;

import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;
import java.nio.charset.Charset;

public class HttpHeaderInterceptor implements ClientHttpRequestInterceptor {


	private final String name;

	private final String value;

	public HttpHeaderInterceptor(String name, String value) {
//		Assert.hasLength(name, "Name must not be empty");
//		Assert.hasLength(value, "Value" + " must not be empty");
		this.name = name;
		this.value = value;
	}

	@Override
	public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution)
			throws IOException {
		request.getHeaders().add(this.name, this.value);
		charsetToUTF8(request);
		return execution.execute(request, body);
	}

	private void charsetToUTF8(HttpRequest request) {
		MediaType contentType = request.getHeaders().getContentType();
		if(contentType.getCharset() == null || Charset.forName("UTF-8") != contentType.getCharset()) {
			contentType = new MediaType(contentType, Charset.forName("UTF-8"));
			request.getHeaders().setContentType(contentType);
		}

	}
}
