package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.biz.enums.QuestionStatusEnum;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户问题表
 * </p>
 *
 * @author liuyang
 * @since 2021-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("question")
public class QuestionPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 课程ID
     */
    private Long courseId;

    /**
     * 章节ID
     */
    private Long chapterId;

    /**
     * 问题内容
     */
    private String content;

    /**
     * 状态：待回复、已回复、已完成
     */
    private QuestionStatusEnum status;


}
