package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.qkdata.biz.enums.CourseAllowEnum;
import com.qkdata.biz.enums.CourseChargeModelEnum;
import com.qkdata.biz.enums.CourseModelEnum;
import com.qkdata.biz.enums.CourseStatusEnum;
import com.qkdata.biz.management.entity.*;
import com.qkdata.biz.management.mapper.*;
import com.qkdata.biz.management.vo.*;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 课程管理 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Service
public class CourseService extends ServiceImpl<CourseMapper, CoursePO> {
    @Autowired
    private AllowOrgCourseMapper allowOrgCourseMapper;
    @Autowired
    private CourseChapterMapper chapterMapper;
    @Autowired
    private CourseSeriesMapper seriesMapper;
    @Autowired
    private CourseTagRelMapper tagRelMapper;
    @Autowired
    private CourseTagService tagService;
    @Autowired
    private TeacherService teacherService;

    public PageResult<CourseListItemModel> queryPageList(QueryCourseModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<CourseListItemModel> list = baseMapper.queryPageList(page,param);
        for (CourseListItemModel course : list){
            List<CourseTagPO> tagsList = tagService.findListByCourseId(course.getId());
            if (CollUtil.isNotEmpty(tagsList)){
                List<String> tagNameList = tagsList.stream().map(CourseTagPO::getName).collect(Collectors.toList());
                course.setTags(tagNameList);
            }
        }
        return PageResult.<CourseListItemModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    @Transactional
    public Long saveStep1(CourseStep1SaveModel model) {
        CoursePO po = convertToPO(model);
        if (po.getId() == null){
            save(po);
        }else {
            updateById(po);
        }

        if (CollUtil.isNotEmpty(model.getTagIds())){
            updateCourseTags(po.getId(),model.getTagIds());
        }
        if (model.getAllow() == CourseAllowEnum.SPECIFY){
            updateCourseAllowOrg(po.getId(),model.getAllowOrgIds());
        }
        return po.getId();
    }

    private void updateCourseAllowOrg(Long id, List<Long> allowOrgIds) {
        //TODO
    }

    private void updateCourseTags(Long id, List<Long> tagIds) {
        //TODO
    }

    private CoursePO convertToPO(CourseStep1SaveModel model) {
        CoursePO po = new CoursePO();
        po.setId(model.getId());
        po.setName(model.getName());
        po.setType(model.getType());
        po.setIntroduce(model.getIntroduce());
        po.setDetail(model.getDetail());
        po.setLogoUrl(model.getLogoUrl());
        po.setStatus(CourseStatusEnum.UP);
        po.setTeacherId(model.getTeacherId());
        po.setChargeModel(model.getChargeModel());
        if (po.getChargeModel() == CourseChargeModelEnum.PAY){
            po.setPrice(model.getPrice());
            po.setValidPeriod(model.getValidPeriod());
            po.setVipPrice(model.getVipPrice());
        }
        po.setModel(CourseModelEnum.VOD);
        po.setAllow(model.getAllow());
        po.setSeriesId(model.getSeriesId());
        return po;
    }

    @Transactional
    public void saveStep2(List<CourseChaperModel> chaperList) {
        for (CourseChaperModel model : chaperList){
            CourseChapterPO po = new CourseChapterPO();
            po.setCourseId(model.getCourseId());
            po.setName(model.getName());
            po.setResourceId(model.getResourceId());
            chapterMapper.insert(po);
        }

    }

    public CourseDetailModel getCourseDetail(Long id) {
        CoursePO po = getById(id);
        if (po == null){
            throw new BusinessException("请求错误，课程不存在");
        }
        CourseDetailModel model = new CourseDetailModel();
        BeanUtils.copyProperties(po,model);
        addTeacherInfo(model);
        addSeriesInfo(model);
        addTags(model);
        //TODO
        return model;
    }

    private void addTags(CourseDetailModel model) {
        List<CourseTagsModel> tags = tagRelMapper.selectModelList(model.getId());
        model.setTagList(tags);
    }

    private void addSeriesInfo(CourseDetailModel model) {
        CourseSeriesPO po = seriesMapper.selectById(model.getSeriesId());
        if (po != null){
            model.setSeriesName(po.getName());
        }
    }

    private void addTeacherInfo(CourseDetailModel model) {
        TeacherPO teacherPO = teacherService.getById(model.getTeacherId());
        if (teacherPO != null){
            model.setTeacherName(teacherPO.getName());
        }
    }

    public void modifyChaperName(ModifyChaperNameModel model) {
        CourseChapterPO po = chapterMapper.selectById(model.getChaperId());
        if (po == null){
            throw new BusinessException("请求错误，章节不存在");
        }
        po.setName(model.getChaperName());
        chapterMapper.updateById(po);
    }

    public void delChaper(Long chaperId) {
        chapterMapper.deleteById(chaperId);
    }

    public void modifyStatus(ModifyCourseStatusModel model) {
        baseMapper.updateStatusById(model.getId(),model.getStatus());
    }
}