package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.vo.*;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 课程 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Api(tags = "课程管理")
@RestController
@RequestMapping("/api/mgr/course")
public class CourseController {

    @Autowired
    private CourseService courseService;

    @ApiOperation("课程查询")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<CourseListItemModel> list(@RequestBody QueryCourseModel param){

        return courseService.queryPageList(param);
    }
    @ApiOperation("获取课程详情")
    @GetMapping("/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<CourseDetailModel> courseDetail(@PathVariable Long id){
        return Result.succeed(courseService.getCourseDetail(id));
    }
    @ApiOperation("课程上、下架操作")
    @PostMapping("/modifyStatus")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> modifyStatus(@RequestBody ModifyCourseStatusModel model){
        courseService.modifyStatus(model);
        return Result.succeed("ok");
    }
    @ApiOperation("添加课程(第一步保存)")
    @PostMapping("/saveStep1")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    @SysLog(value = "添加课程",includeParam = false)
    public Result<Long> saveStep1(@RequestBody CourseStep1SaveModel model){
        Long id = courseService.saveStep1(model);
        return Result.succeed(id);
    }
    @ApiOperation("添加课程（第二步保存）")
    @PostMapping("/saveStep2")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> saveStep2(@RequestBody List<CourseChaperModel> chaperList){
        courseService.saveStep2(chaperList);
        return Result.succeed("ok");
    }
    @ApiOperation("修改章节名称")
    @PostMapping("/modifyChaperName")
    @SysLog("修改章节名称")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> modifyChaperName(@RequestBody ModifyChaperNameModel model){
        courseService.modifyChaperName(model);
        return Result.succeed("ok");
    }
    @ApiOperation("删除章节")
    @GetMapping("/delChaper/{chaperId}")
    @SysLog("删除章节")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delChaper(@PathVariable Long chaperId){
        courseService.delChaper(chaperId);
        return Result.succeed("ok");
    }
}
