package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.vo.PriceConfigModel;
import com.qkdata.biz.sys.entity.SysConfigPO;
import com.qkdata.biz.sys.service.SysConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class PriceConfigService {
    @Autowired
    private SysConfigService sysConfigService;
    private List<String> paramKeys = Lists.newArrayList(
            BizConstants.CONFIG_KEY_VIP_PRICE,
            BizConstants.CONFIG_KEY_DISCOUNT_3MON,
            BizConstants.CONFIG_KEY_DISCOUNT_6MON,
            BizConstants.CONFIG_KEY_DISCOUNT_12MON,
            BizConstants.CONFIG_KEY_ENTERPRICE_VIP_PRICE);
    private String configType = "PriceConfig";

    public PriceConfigModel findConfig() {

        List<SysConfigPO> configList = sysConfigService.list(Wrappers.<SysConfigPO>lambdaQuery().in(SysConfigPO::getType, configType));
        PriceConfigModel model = new PriceConfigModel();
        if (CollUtil.isNotEmpty(configList)) {
            for (SysConfigPO config : configList) {
                switch (config.getKey()) {
                    case BizConstants.CONFIG_KEY_VIP_PRICE:
                        model.setVipPrice(new BigDecimal(config.getValue()));
                        break;
                    case BizConstants.CONFIG_KEY_DISCOUNT_3MON:
                        model.setDiscountFor3Mon(new BigDecimal(config.getValue()));
                        break;
                    case BizConstants.CONFIG_KEY_DISCOUNT_6MON:
                        model.setDiscountFor6Mon(new BigDecimal(config.getValue()));
                        break;
                    case BizConstants.CONFIG_KEY_DISCOUNT_12MON:
                        model.setDiscountFor12Mon(new BigDecimal(config.getValue()));
                        break;
                    case BizConstants.CONFIG_KEY_ENTERPRICE_VIP_PRICE:
                        model.setEnterpriceVipPrice(new BigDecimal(config.getValue()));
                        break;
                }
            }
        }
        return model;
    }

    public void update(PriceConfigModel model) {
        for (String paramKey : paramKeys) {
            switch (paramKey) {
                case BizConstants.CONFIG_KEY_VIP_PRICE:
                    sysConfigService.updateValueByKey(BizConstants.CONFIG_KEY_VIP_PRICE, model.getVipPrice().toString());
                    break;
                case BizConstants.CONFIG_KEY_DISCOUNT_3MON:
                    sysConfigService.updateValueByKey(BizConstants.CONFIG_KEY_DISCOUNT_3MON, model.getVipPrice().toString());
                    break;
                case BizConstants.CONFIG_KEY_DISCOUNT_6MON:
                    sysConfigService.updateValueByKey(BizConstants.CONFIG_KEY_DISCOUNT_6MON, model.getVipPrice().toString());
                    break;
                case BizConstants.CONFIG_KEY_DISCOUNT_12MON:
                    sysConfigService.updateValueByKey(BizConstants.CONFIG_KEY_DISCOUNT_12MON, model.getVipPrice().toString());
                    break;
                case BizConstants.CONFIG_KEY_ENTERPRICE_VIP_PRICE:
                    sysConfigService.updateValueByKey(BizConstants.CONFIG_KEY_ENTERPRICE_VIP_PRICE, model.getVipPrice().toString());
                    break;
            }
        }
    }


}
