package com.qkdata.common.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.qkdata.common.converter.*;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

@Configuration
public class JacksonConfiguration {


    @Bean
    public Jackson2ObjectMapperBuilderCustomizer objectMapper() {
        return builder -> builder.failOnEmptyBeans(false)
                                 .failOnUnknownProperties(false)
                                 .createXmlMapper(false)
//                                 .serializationInclusion(JsonInclude.Include.NON_EMPTY)
//                                 .serializationInclusion(JsonInclude.Include.NON_NULL)
                                .serializerByType(Date.class,new DateSerializer())
                                .deserializerByType(Date.class,new DateDeserializer())
                                 .serializerByType(LocalDate.class, new LocalDateSerializer())
                                 .deserializerByType(LocalDate.class, new LocalDateDeserializer())
                                 .serializerByType(LocalDateTime.class, new LocalDateTimeSerializer())
                                 .deserializerByType(LocalDateTime.class, new LocalDateTimeDeserializer())
                                 .featuresToDisable(DeserializationFeature.READ_ENUMS_USING_TO_STRING)
                                 .featuresToDisable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}
