package com.qkdata.biz.web.vo;

import com.qkdata.biz.enums.CourseStatusEnum;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class CourseConsumeRecordModel {
    /**
     * 记录ID
     */
    private String id;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 课程ID
     */
    private Long courseId;
    /**
     * 课程名称
     */
    private String courseName;
    /**
     * 章节ID
     */
    private Long chapterId;
    /**
     * 章节名称
     */
    private String chapterName;
    /**
     * 本次看时长（秒）
     */
    private Long watchTime;
    /**
     * 观看到视频的时间（秒）
     */
    private Long videoTime;

    /**
     * 课程状态
     */
    private CourseStatusEnum courseStatus;
    /**
     * 视频快照url
     */
    private String logoUrl;
    /**
     * 最后观看时间
     */
    private LocalDateTime updateTime;
    /**
     * 视频ID
     */
    private String videoId;
}
