package com.qkdata.biz.sms.service;

import com.qkdata.biz.sms.vo.SmsRequest;
import com.qkdata.biz.sms.vo.SmsResponse;
import com.qkdata.biz.sms.vo.SmsV2Condition;
import com.qkdata.common.base.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;

@Slf4j
@Service
public class SmsService {

    @Value("${sms.api.v3}")
    private String api;


    @Autowired
    private RestTemplate restTemplate;

    public void sendSmsV3(SmsV2Condition condition) {

        SmsRequest smsRequest = new SmsRequest(Collections.singletonList(condition));
        SmsResponse smsResponse = restTemplate.postForObject(api, smsRequest, SmsResponse.class);
        if (smsResponse == null || smsResponse.hasError()) {
            log.error("短信发送失败：{}", smsResponse, toString());
            throw new BusinessException("短信发送失败");
        }


    }

}
