package com.qkdata.biz.management.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.qkdata.common.base.entity.BasePO;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 用户标签
 * </p>
 *
 * @author liuyang
 * @since 2021-09-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("user_tag")
public class UserTagPO extends BasePO {

    private static final long serialVersionUID = 1L;

    /**
     * 用户标签名称
     */
    @NotBlank(message = "名称不能为空")
    @Length(min = 1,max = 6,message = "名称最多6个字符")
    private String name;


}
