/******************
 * 字典管理
 *****************/

// 导入请求公用方法
import {
    request
} from '../../utils/axiosFun';

export const fetchList = (query) => {
    return request('post', '/api/sys/config/list', query)
}

export const addObj = (obj) => {
    return request('post', '/api/sys/config/save', obj)
}

export const getObj = (id) => {
    return request('get', '/api/sys/config/info/' + id)
}

export const delObj = (ids) => {
    return request('post', '/api/sys/config/delete', ids)
}

export const putObj = (obj) => {
    return request('post', '/api/sys/config/update', obj)
}
